<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://example.com
 * @since             1.0.0
 * @package           Alfa_Tools
 *
 * @wordpress-plugin
 * Plugin Name:       Alfa Tools
 * Plugin URI:        http://alfa-phone.com
 * Description:       Alfa tools plugin
 * Version:           1.0.6
 * Author:            Andrew Studenov
 * Author URI:        http://a-studenov.ru/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       alfa-tools
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'ALFA_TOOLS_VERSION', '1.0.6' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-alfa-tools-activator.php
 */
function activate_alfa_tools() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-alfa-tools-activator.php';
	Alfa_Tools_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-alfa-tools-deactivator.php
 */
function deactivate_alfa_tools() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-alfa-tools-deactivator.php';
	Alfa_Tools_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_alfa_tools' );
register_deactivation_hook( __FILE__, 'deactivate_alfa_tools' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-alfa-tools.php';

require_once plugin_dir_path( __FILE__ ) . 'includes/class-alfa-tools-updater.php';


/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_alfa_tools() {

	$plugin = new Alfa_Tools();
	$plugin->run();
	new Alfa_Tools_Updater( __FILE__, ALFA_TOOLS_VERSION );

}
run_alfa_tools();