<?php
use PhpOffice\PhpSpreadsheet\IOFactory;
use TrueBV\Punycode;
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://example.com
 * @since      1.0.0
 *
 * @package    Alfa_Tools
 * @subpackage Alfa_Tools/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Alfa_Tools
 * @subpackage Alfa_Tools/admin
 * @author     Your Name <email@example.com>
 */
class Alfa_Tools_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $alfa_tools    The ID of this plugin.
	 */
	private $alfa_tools;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $alfa_tools       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $alfa_tools, $version ) {

		$this->alfa_tools = $alfa_tools;
		$this->version = $version;
		if (is_multisite()) {
            add_action('network_admin_menu', function(){
                add_menu_page( 'ALFA Tools', 'ALFA Tools', 'manage_options', 'alfa-tools', array($this, 'admin_page'), '', 4 );
            } );
		} else {
		    add_action('admin_menu', function(){
                add_menu_page( 'ALFA Tools', 'ALFA Tools', 'manage_options', 'alfa-tools', array($this, 'admin_page'), '', 4 );
            } );
		}
	}

    public function admin_page() {
		if (is_multisite()) {
			$this_url = 'network/admin.php?page=alfa-tools';
		} else {
			$this_url = 'admin.php?page=alfa-tools';
		}

		// Сохранение настроек
		if (isset($_POST['secret_key']) && $_POST['secret_key'] != '') {
			update_option('_alfa_tools_secret_key', sanitize_text_field($_POST['secret_key']));
		}

		// Сохраняем позиции иконки
		$fields = ['top', 'left', 'right', 'bottom'];
		foreach ($fields as $field) {
			if (isset($_POST['whatsapp_'.$field])) {
				update_option('_alfa_tools_whatsapp_'.$field, sanitize_text_field($_POST['whatsapp_'.$field]));
			}
		}

		if (!empty($_POST)) {
			?>
			<div class="notice notice-success is-dismissible">
				<p>Настройки обновлены!</p>
			</div>
			<?php
		}

		// Получаем текущие значения
		$secret_key = get_option('_alfa_tools_secret_key');
		$whatsapp_top = get_option('_alfa_tools_whatsapp_top', '');
		$whatsapp_left = get_option('_alfa_tools_whatsapp_left', '');
		$whatsapp_right = get_option('_alfa_tools_whatsapp_right', '');
		$whatsapp_bottom = get_option('_alfa_tools_whatsapp_bottom', '');

		?>
		<h1>Настройки Alfa Tools</h1>

		<form action="<?php echo esc_url(get_admin_url(null, $this_url)); ?>" method="post" style="max-width:600px;">
			<table class="form-table">
				<tr>
					<th scope="row"><label for="secret_key">Секретный ключ Alfa Tools</label></th>
					<td><input type="text" id="secret_key" name="secret_key" value="<?php echo esc_attr($secret_key); ?>" class="regular-text"></td>
				</tr>
			</table>

			<h2>Позиционирование иконки WhatsApp</h2>
			<p>Укажите отступы в пикселях или процентах (например, <code>40px</code> или <code>10%</code>). Оставьте поле пустым, если не нужно задавать значение.</p>

			<table class="form-table">
				<tr>
					<th><label for="whatsapp_top">Отступ сверху (top)</label></th>
					<td><input type="text" id="whatsapp_top" name="whatsapp_top" value="<?php echo esc_attr($whatsapp_top); ?>" class="small-text"></td>
				</tr>
				<tr>
					<th><label for="whatsapp_bottom">Отступ снизу (bottom)</label></th>
					<td><input type="text" id="whatsapp_bottom" name="whatsapp_bottom" value="<?php echo esc_attr($whatsapp_bottom); ?>" class="small-text"></td>
				</tr>
				<tr>
					<th><label for="whatsapp_left">Отступ слева (left)</label></th>
					<td><input type="text" id="whatsapp_left" name="whatsapp_left" value="<?php echo esc_attr($whatsapp_left); ?>" class="small-text"></td>
				</tr>
				<tr>
					<th><label for="whatsapp_right">Отступ справа (right)</label></th>
					<td><input type="text" id="whatsapp_right" name="whatsapp_right" value="<?php echo esc_attr($whatsapp_right); ?>" class="small-text"></td>
				</tr>
			</table>

			<p><input type="submit" class="button button-primary" value="Сохранить изменения"></p>
		</form>
		<?php
	}


	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Alfa_Tools_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Alfa_Tools_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->alfa_tools, plugin_dir_url( __FILE__ ) . 'css/alfa-tools-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Alfa_Tools_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Alfa_Tools_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->alfa_tools, plugin_dir_url( __FILE__ ) . 'js/alfa-tools-admin.js', array( 'jquery' ), $this->version, false );

	}

}
